% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{class}
\name{Table}
\alias{Table}
\title{Table class}
\description{
A Table is a sequence of \link[=ChunkedArray]{chunked arrays}. They
have a similar interface to \link[=RecordBatch]{record batches}, but they can be
composed from multiple record batches or chunked arrays.
}
\section{Factory}{


The \code{Table$create()} function takes the following arguments:
\itemize{
\item \code{...} arrays, chunked arrays, or R vectors, with names; alternatively,
an unnamed series of \link[=RecordBatch]{record batches} may also be provided,
which will be stacked as rows in the table.
\item \code{schema} a \link{Schema}, or \code{NULL} (the default) to infer the schema from
the data in \code{...}
}
}

\section{S3 Methods and Usage}{

Tables are data-frame-like, and many methods you expect to work on
a \code{data.frame} are implemented for \code{Table}. This includes \code{[}, \code{[[},
\code{$}, \code{names}, \code{dim}, \code{nrow}, \code{ncol}, \code{head}, and \code{tail}. You can also pull
the data from an Arrow table into R with \code{as.data.frame()}. See the
examples.

A caveat about the \code{$} method: because \code{Table} is an \code{R6} object,
\code{$} is also used to access the object's methods (see below). Methods take
precedence over the table's columns. So, \code{tab$Slice} would return the
"Slice" method function even if there were a column in the table called
"Slice".

A caveat about the \code{[} method for row operations: only "slicing" is
currently supported. That is, you can select a continuous range of rows
from the table, but you can't filter with a \code{logical} vector or take an
arbitrary selection of rows by integer indices.
}

\section{R6 Methods}{

In addition to the more R-friendly S3 methods, a \code{Table} object has
the following R6 methods that map onto the underlying C++ methods:
\itemize{
\item \verb{$column(i)}: Extract a \code{ChunkedArray} by integer position from the table
\item \verb{$ColumnNames()}: Get all column names (called by \code{names(tab)})
\item \verb{$GetColumnByName(name)}: Extract a \code{ChunkedArray} by string name
\item \verb{$field(i)}: Extract a \code{Field} from the table schema by integer position
\item \verb{$select(spec)}: Return a new table with a selection of columns.
This supports the usual \code{character}, \code{numeric}, and \code{logical} selection
methods as well as "tidy select" expressions.
\item \verb{$Slice(offset, length = NULL)}: Create a zero-copy view starting at the
indicated integer offset and going for the given length, or to the end
of the table if \code{NULL}, the default.
\item \verb{$Take(i)}: return an \code{Table} with rows at positions given by
integers \code{i}. If \code{i} is an Arrow \code{Array} or \code{ChunkedArray}, it will be
coerced to an R vector before taking.
\item \verb{$Filter(i)}: return an \code{Table} with rows at positions where logical
vector or Arrow boolean-type \verb{(Chunked)Array} \code{i} is \code{TRUE}.
\item \verb{$serialize(output_stream, ...)}: Write the table to the given
\link{OutputStream}
\item \verb{$cast(target_schema, safe = TRUE, options = cast_options(safe))}: Alter
the schema of the record batch.
}

There are also some active bindings
\itemize{
\item \verb{$num_columns}
\item \verb{$num_rows}
\item \verb{$schema}
\item \verb{$columns}: Returns a list of \code{ChunkedArray}s
}
}

\examples{
\donttest{
tab <- Table$create(name = rownames(mtcars), mtcars)
dim(tab)
dim(head(tab))
names(tab)
tab$mpg
tab[["cyl"]]
as.data.frame(tab[4:8, c("gear", "hp", "wt")])
}
}
