% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clustering}
\alias{clustering}
\title{To obtain the dendrogram of the covariates contained in the data.frame X, and a proposition for the number of clusters of covariates in X.}
\usage{
clustering(X, plot = TRUE)
}
\arguments{
\item{X}{the matrix (or data.frame) of covariates, dimension n*p (n is the sample size, p the number of covariates).}

\item{plot}{if plot = TRUE" (default value): it gives the dendrogram and the plot of the height versus the number of clusters, for the 30 first clusters.}
}
\value{
a 2-list composed by: "tree" (the dendrogram of X), and "nclust" which is a proposition of the number of clusters. The proposed number of clusters is calculated as following: in the graph of the decreasing height versus the number of clusters, we define variation_height = (height[1:29]-height[2:30])/height[2:30], and our proposition is nclust=min(which(variation_height<0.05)). It is preferable that the user chooses its own number of clusters. Warning: nclust must be not too high. Indeed, if nclust is too high, the clusters contain a small number of covariates, and it is then possible that all the covariates of one or several cluster(s) are included in H0. In that case, the FAMT procedure will have a dysfunction.
}
\description{
To obtain the dendrogram of the covariates contained in the data.frame X, and a proposition for the number of clusters of covariates in X.
}
\examples{
toys.data
X<-toys.data$x
clustering(X)

}
