% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_ari.R
\name{gs_to_ari}
\alias{gs_to_ari}
\alias{pptx_to_pdf}
\alias{pptx_to_pngs}
\alias{pptx_to_ari}
\alias{pdf_to_ari}
\alias{html_to_ari}
\alias{pdf_to_pngs}
\alias{images_to_ari}
\alias{to_ari}
\title{Convert Google Slides and notes to video with ari}
\usage{
gs_to_ari(path, script = NULL, ..., verbose = TRUE)

pptx_to_pdf(path, verbose = TRUE)

pptx_to_pngs(path, verbose = TRUE, dpi = 600)

pptx_to_ari(path, script = NULL, ..., verbose = TRUE)

pdf_to_ari(path, script = NULL, dpi = 300, ..., verbose = TRUE)

html_to_ari(path, script = NULL, ..., verbose = TRUE)

pdf_to_pngs(path, verbose = TRUE, dpi = 600)

images_to_ari(path, script = NULL, dpi = 300, ..., verbose = TRUE)

to_ari(path, script = NULL, ..., verbose = TRUE)
}
\arguments{
\item{path}{Identifier of google slides presentation, or PPTX filename}

\item{script}{passed to \code{\link[=make_ari_document]{make_ari_document()}}}

\item{...}{Arguments passed to \link{make_ari_document}}

\item{verbose}{print diagnostic messages}

\item{dpi}{resolution (dots per inch) to render images}
}
\value{
The output from \link{make_ari_document}
}
\description{
Convert Google Slides and notes to video with ari
}
\examples{
\donttest{
# takes > 5 seconds to run
  id = "1Opt6lv7rRi7Kzb9bI0u3SWX1pSz1k7botaphTuFYgNs"
  res = gs_to_ari(id, verbose = 2, open = FALSE)
  if (interactive()) {
    file.edit(res$output_file)
  }
  # replicates same thing as above without verbosity
  res2 = to_ari(id, open = FALSE)
}

ex_file = system.file("extdata", "example.pptx", package = "ariExtra")
have_soffice = try(docxtractr:::lo_assert())
if (!inherits(have_soffice, "try-error")) {
pngs = pptx_to_pngs(ex_file)
res = pptx_to_ari(ex_file, open = FALSE)
if (interactive()) {
file.edit(res$output_file)
}
res2 = to_ari(ex_file, open = FALSE)
}
ex_file = system.file("extdata", "example.pdf", package = "ariExtra")
res = pdf_to_ari(ex_file, script = c("hey", "ho"), open = FALSE)
if (interactive()) {
file.edit(res$output_file)
}
\donttest{
res2 = to_ari(ex_file,  script = c("hey", "ho"), open = FALSE)
}
}
