% Generated by roxygen2 (4.0.1): do not edit by hand
\name{add.argument}
\alias{add.argument}
\title{Add an argument to a parser.}
\usage{
add.argument(parser, arg, help, default = NULL, type = NULL, flag = NULL,
  short = NULL)
}
\arguments{
\item{parser}{an arg.parser object}

\item{arg}{argument name (use no prefix for positional arguments,
\code{--} or \code{-} prefix for optional arguments or flags)}

\item{help}{help description for the argument}

\item{default}{default value for the argument [default: NA]}

\item{type}{variable type of the argument (which can be inferred from
\code{default}), assumed to be \code{character} otherwise}

\item{flag}{whether argument is a flag (and does not consume a value)
[default: FALSE]}

\item{short}{short-form for flags and positional arguments;
short-forms can be assigned automatically based on the first
character of the argument name, unless a conflict arises with
an existing short-form; to avoid conflicts, add the argument
as early as possible}
}
\value{
an arg.parser object with the argument added
}
\description{
This function adds an argument to an arg.parser object and returns the
modified object.
}
\details{
This function supports multiple arguments in a vector. To ensure that the
argument variable type is set correctly, either specify \code{type} directly
or supply \code{default} argument values as a list. Arguments that consume
more than one values are not supported.
}
\examples{
p <- arg.parser("A text file modifying program");

# add a positional argument
p <- add.argument(p, "input", help="input file");

# add an optional argument
p <- add.argument(p, "--output", help="output file", default="output.txt");

# add a flag
p <- add.argument(p, "--append", help="append to file", flag=TRUE);

# add multiple arguments together
p <- add.argument(p,
    c("ref", "--date", "--sort"),
    help = c("reference file", "date stamp to use", "sort lines"),
    flag = c(FALSE, FALSE, TRUE));

# print the help message
print(p);
}

