% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataparsing.R
\name{load_data}
\alias{load_data}
\title{Parsing of raw data}
\usage{
load_data(type = "extdata", ili.weighted = TRUE)
}
\arguments{
\item{type}{the type of the data to be loaded. If \code{type=="extdata"} it loads the data
to reproduce the PNAS paper, and if \code{type=="athdata"} it loads the data to reproduce the
CID(?) paper.}

\item{ili.weighted}{logical indicator to specify whether to load weighted ILI or not,
if \code{FALSE} unweighted ILI is loaded.}
}
\value{
A list of following named xts objects if \code{type=="extdata"}
\itemize{
 \item \code{GC10} Google Correlate trained with ILI available as of 2010.
   Google Correlate has been deprecated by Google as of Dec 2019 and is no longer publicly available.
 \item \code{GC09} Google Correlate trained with ILI available as of 2009.
 \item \code{GT} Google Trends data for search queries identified using Google Correlate.
   Not directly available online, you have to manually input query terms
   at \url{https://trends.google.com/trends/}
 \item \code{CDC} CDC's ILI dataset.
   Available online at \url{https://gis.cdc.gov/grasp/fluview/fluportaldashboard.html}
 \item \code{GFT} Google Flu Trend (historical predictions).
}

A list of following named xts objects if \code{type=="athdata"}
\itemize{
 \item \code{GT} Google Trends data for search queries identified.
   Not directly available online, you have to manually input query terms
   at \url{https://trends.google.com/trends/}
 \item \code{CDC} CDC's ILI dataset.
   Available online at \url{https://gis.cdc.gov/grasp/fluview/fluportaldashboard.html}
 \item \code{ili_idx} the indexing information that includes the week number and year
 number, the date of ending Saturday, and the season number
   Available online at \url{https://www.cdc.gov/flu/weekly/}
 \item \code{ATH} Athenahealth data that includes the proportion of "Flu Visit",
 "ILI Visit", and "Unspecified Viral or ILI Visit" compared to total number of visit to the
 Athenahealth partner healthcare providers.
 \item \code{ili_unrevised} Historical unrevised ILI activity level.
   The unrevised ILI published on week ZZ of season XXXX-YYYY is available at
   \code{www.cdc.gov/flu/weekly/weeklyarchivesXXXX-YYYY/data/senAllregtZZ.html}
   or \code{.htm}. For example, original ILI report for week 7 of season 2015-2016 is available at
   \url{https://www.cdc.gov/flu/weekly/weeklyarchives2015-2016/data/senAllregt07.html},
   and original ILI report for week 50 of season 2012-2013 is available at
   \url{https://www.cdc.gov/flu/weekly/weeklyarchives2012-2013/data/senAllregt50.htm}
}
}
\description{
Data related to the PNAS paper. Accessed on Nov 14, 2015.
}
\details{
Parse and load CDC's ILI data, Google Flu Trend data,
Google Correlate data trained with ILI as of 2010, Google Correlate data trained with ILI as of 2009,
Google Trend data with search terms identified from Google Correlate (2010 version).

Each week ends on the Saturday indicated in the xts object

Google Correlate data is standardized by Google, and we rescale it to 0 -- 100 during parsing.
Google Trends data is in the scale of 0 -- 100.
}
\examples{
system.file("extdata", "correlate-Influenza_like_Illness_h1n1_CDC_.csv", package = "argo")
system.file("extdata", "correlate-Influenza_like_Illness_CDC_.csv", package = "argo")
system.file("extdata", "GFT.csv", package = "argo")
system.file("extdata", "ILINet.csv", package = "argo")
load_data()

}
\references{
Yang, S., Santillana, M., & Kou, S. C. (2015). Accurate estimation of influenza epidemics using Google search data via ARGO. Proceedings of the National Academy of Sciences. <doi:10.1073/pnas.1515373112>.
}
