% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeExampleDB.R
\name{makeExampleDB}
\alias{makeExampleDB}
\title{Build an example database}
\usage{
makeExampleDB(until = NULL, path = NULL, verbose = FALSE)
}
\arguments{
\item{until}{[\code{character(1)}]\cr The database building step in terms of
the function names until which the example database shall be built, one of
\code{"setPath"}, \code{"setVariables"}, \code{"regDataseries"},
\code{"regGeometry"}, \code{"regTable"}, \code{"normGeometry"} or
\code{"normTable"}.}

\item{path}{[\code{character(1)}]\cr The database gets created by default in
tempdir(), but if you want it in a particular location, specify that in
this argument.}

\item{verbose}{[\code{logical(1)}]\cr be verbose about building the example
database (default \code{FALSE}).}
}
\value{
No return value, called for the side effect of creating an example
  database at the specified \code{path}.
}
\description{
This function helps setting up an example database up until a certain point.
}
\examples{
# to merely register a set of files
makeExampleDB(until = "regTable")

# to build the full example database
makeExampleDB()

}
