% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createEmptyRepo.R
\name{createEmptyRepo}
\alias{createEmptyGithubRepo}
\alias{createEmptyLocalRepo}
\alias{createEmptyRepo}
\title{Create an Empty Repository}
\usage{
createEmptyRepo(repoDir, force = TRUE, default = FALSE, repoName,
  github_token = aoptions("github_token"),
  user.name = aoptions("user.name"),
  user.password = aoptions("user.password"),
  repoDescription = aoptions("repoDescription"),
  readmeDescription = aoptions("readmeDescription"),
  response = aoptions("response"), type = "local")

createEmptyLocalRepo(repoDir, force = TRUE, default = FALSE)

createEmptyGithubRepo(repoName, github_token = aoptions("github_token"),
  user.name = aoptions("user.name"),
  user.password = aoptions("user.password"),
  repoDescription = aoptions("repoDescription"),
  readmeDescription = aoptions("readmeDescription"),
  response = aoptions("response"))
}
\arguments{
\item{repoDir}{A character that specifies the directory for the Repository which is to be made.}

\item{force}{If \code{force = TRUE} and \code{repoDir} parameter specifies the directory that doesn't exist,
then function call will force to create new \code{repoDir} directory.
Default set to \code{force = TRUE}.}

\item{default}{If \code{default = TRUE} then \code{repoDir} is set as default local repository.}

\item{repoName}{While working with a Github repository. A character denoting new GitHub repository name. White spaces will be substitued with a dash.}

\item{github_token}{While working with a Github repository. An OAuth GitHub Token created with the \link{oauth2.0_token} function. See \link{archivist-github-integration}.
Can be set globally with \code{aoptions("github_token", github_token)}.}

\item{user.name}{While working with a Github repository. A character denoting GitHub user name. Can be set globally with \code{aoptions("user.name", user.name)}.
See \link{archivist-github-integration}.}

\item{user.password}{While working with a Github repository. A character denoting GitHub user password. Can be set globally with \code{aoptions("user.password", user.password)}.
See \link{archivist-github-integration}.}

\item{repoDescription}{While working with a Github repository. A character specifing the new GitHub repository description.}

\item{readmeDescription}{While working with a Github repository. A character of the content of \code{README.md} file. By default a description of \link{Repository}.
Can be set globally with \code{aoptions("readmeDescription", readmeDescription)}. For no \code{README.md} file
set \code{aoptions("readmeDescription", NULL)}.}

\item{response}{A logical value. Should the GitHub API response should be returned.}

\item{type}{A character. Whether to use \code{Local} or \code{Github} version while using \code{createEmptyRepo} wrapper.}
}
\description{
\code{createEmptyLocalRepo} creates an empty \link{Repository} in the given directory in which archived artifacts will be stored.
\code{createEmptyGithubRepo} creates a new GitHub repository with an empty \pkg{archivist}-like \link{Repository} and
also creates a local \code{Repository} with \code{createEmptyLocalRepo} which is git-synchronized with
new GitHub repository. \code{createEmptyRepo} is a wrapper around \code{createEmptyLocalRepo} and \code{createEmptyGithubRepo}
 functions and by default triggers \code{createEmptyLocalRepo} to maintain consistency with the previous \pkg{archivist} versions (<1.8.6.0)
 where there was only \code{createEmptyRepo} which created local \code{Repository}. To learn more about
 \code{Archivist Integration With GitHub API} visit \link{archivist-github-integration} (\link{agithub}).
}
\details{
At least one Repository must be initialized before using other functions from the \pkg{archivist} package.
While working in groups, it is highly recommended to create a Repository on a shared Dropbox/Git folder.

All artifacts which are desired to be archived are going to be saved in the local Repository, which is an SQLite
database stored in a file named \code{backpack}.
After calling \code{saveToRepo} function, each artifact will be archived in a \code{md5hash.rda} file.
This file will be saved in a folder (under \code{repoDir} directory) named
\code{gallery}. For every artifact, \code{md5hash} is a unique string of length 32 that is produced by
\link[digest]{digest} function, which uses a cryptographical MD5 hash algorithm.

To learn more about artifacts visit \link[archivist]{archivist-package}.

Created \code{backpack} database is a useful and fundamental tool for remembering artifact's
\code{name}, \code{class}, \code{archiving date} etc. (the so called \link{Tags})
or for keeping artifact's \code{md5hash}.

Besides the \code{backpack} database, \code{gallery} folder is created in which all
artifacts will be archived.

After every \code{saveToRepo} call the database is refreshed. As a result, the artifact is available
immediately in \code{backpack.db} database for other collaborators.
}
\examples{
\dontrun{
exampleRepoDir <- tempfile()
createEmptyRepo( repoDir = exampleRepoDir )

# check the state of an empty Repository

summaryLocalRepo(  repoDir = exampleRepoDir )
showLocalRepo( exampleRepoDir )

# creating a Repository in non existing directory

createEmptyLocalRepo( "xyzdd234") # force = TRUE is default argument

# creating a default local Repository in non existing directory

createEmptyRepo("def", default = TRUE)
data(iris)
saveToRepo(iris) # We don't have to specify repoDir parameter
showLocalRepo() # because repoDir="def" is default

 # removing an example Repositories

deleteRepo( exampleRepoDir, TRUE)
deleteRepo( "xyzdd234", TRUE)
deleteRepo("def", TRUE)

rm( exampleRepoDir )

## GitHub version

library(httr)
myapp <- oauth_app("github",
                   key = app_key,
                   secret = app_secret)
github_token <- oauth2.0_token(oauth_endpoints("github"),
                                myapp,
                                scope = "public_repo")
aoptions("github_token", github_token)
aoptions("user.name", user.name)
aoptions("user.password", user.password)

createEmptyGithubRepo("Museum")
createEmptyGithubRepo("Museum-Extras", response = TRUE)
createEmptyGithubRepo("Gallery", readmeDescription = NULL)
createEmptyGithubRepo("Landfill",
        repoDescription = "My models and stuff")



# empty Github Repository creation

library(httr)
myapp <- oauth_app("github",
                   key = '1fab1e77d27079c0717d',
                   secret = 'c1284ed206b4a7f5f0bca508a6df5919e7fbf799')
github_token <- oauth2.0_token(oauth_endpoints("github"),
                               myapp,
                               scope = "public_repo")
# setting options
aoptions("github_token", github_token)
aoptions("user.name", 'MarcinKosinski')
aoptions("user.password", 'sobieskiego77')

createEmptyGithubRepo("archive-test4")
setGithubRepo(aoptions("user.name"), "archive-test4")
## artifact's archiving
przyklad <- 1:100

# archiving
archive(przyklad) -> md5hash_path

## proof that artifact is really archived
showGithubRepo() # uses options from setGithubRepo
# let's remove przyklad
rm(przyklad)
# and load it back from md5hash_path
aread(md5hash_path)


# clone example
unlink("archive-test", recursive = TRUE)
cloneGithubRepo('https://github.com/MarcinKosinski/archive-test')
setGithubRepo(aoptions("user.name"), "archive-test")
data(iris)
archive(iris)
showGithubRepo()

}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{agithub}},
  \code{\link{archivist-github-integration}};
  \code{\link{ahistory}}; \code{\link{aoptions}};
  \code{\link{archive}}; \code{\link{archivist-package}};
  \code{\link{aread}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{cloneGithubRepo}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{splitTagsGithub}},
  \code{\link{splitTagsLocal}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

