% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dates.R
\name{is_date}
\alias{is_date}
\alias{date_to_ms}
\alias{from_esri_date}
\title{Date handling}
\usage{
is_date(x, tz)

date_to_ms(x, tz = "UTC")

from_esri_date(x)
}
\arguments{
\item{x}{an object of class \code{Date} or \code{POSIXt}. In the case of \code{is_date()}, any R object.}

\item{tz}{a character string.  The time zone specification to be used
    for the conversion, \emph{if one is required}.  System-specific (see
    \link[base]{time zones}), but \code{""} is the current time zone, and
    \code{"GMT"} is UTC (Universal Time, Coordinated).  Invalid values
    are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
\itemize{
\item \code{is_date()} returns a logical scalar
\item \code{date_to_ms()} returns a numeric vector of times in milliseconds from the Unix Epoch in the specified time zone.
}
}
\description{
Esri date fields are represented as milliseconds from the Unix Epoch.
}
\details{
\itemize{
\item \code{is_date()}: checks if an object is a \code{Date} or \code{POSIXt} class object.
\item \code{date_to_ms()} converts a date object to milliseconds from the Unix Epoch in the specified time zone.
}
}
\examples{

today <- Sys.Date()

is_date(today)

date_to_ms(today)

}
