% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkHzDepthLogic.R
\name{hzDepthTests}
\alias{hzDepthTests}
\title{Tests of horizon depth logic}
\usage{
hzDepthTests(top, bottom = NULL)
}
\arguments{
\item{top}{A numeric vector containing horizon top depths. Or a \code{data.frame} with two columns (first containing top depths, second containing bottom)}

\item{bottom}{A numeric vector containing horizon bottom depths.}
}
\value{
A named logical vector containing TRUE for each type of horizon logic error found in the given data.
}
\description{
Function used internally by \code{checkHzDepthLogic()}, \code{glom()} and various other functions that operate on horizon data from single soil profiles and require a priori depth logic checks. Checks for bottom depths less than top depth / bad top depth order ("depthLogic"), bottom depths equal to top depth ("sameDepth"), overlaps/gaps ("overlapOrGap") and missing depths ("missingDepth"). Use \code{names(res)[res]} on result \code{res} of \code{hzDepthTest()} to to determine type of logic error(s) found -- see examples below.
}
\examples{

# no logic errors
res <- hzDepthTests(top = c(0,10,20,30), bottom = c(10,20,30,50))
names(res)[res]

# bottom < top
hzDepthTests(top = c(10,20,30,50), bottom = c(0,10,20,30))
names(res)[res]

# bottom == top
hzDepthTests(top = c(10,20,30,50), bottom = c(0,20,20,30))
names(res)[res]

# overlap
hzDepthTests(top = c(0,5,20,30), bottom = c(10,20,30,50))
names(res)[res]

# gap
hzDepthTests(top = c(0,15,20,30), bottom = c(10,20,30,50))
names(res)[res]

# missing
hzDepthTests(c(0,15,NA,30),c(10,NA,30,50))
names(res)[res]

}
\author{
Andrew G. Brown & Dylan E. Beaudette
}
