% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertLabelColor.R
\name{invertLabelColor}
\alias{invertLabelColor}
\title{Make High Contrast Label Colors}
\usage{
invertLabelColor(colors, threshold = 0.65)
}
\arguments{
\item{colors}{vector of colors}

\item{threshold}{black | white threshold}
}
\value{
vector of label colors
}
\description{
Generate a vector of white or black label colors conditioned on a vector of colors to maximize label contrast.
}
\examples{

# test with shades of grey
s <- seq(0, 1, by = 0.05)
cols <- grey(s)
soilPalette(cols, lab = as.character(s))

# test with 10YR x/3
m <- sprintf('10YR \%s/3', 1:8)
cols <- parseMunsell(m)
soilPalette(cols, lab = m)


}
\author{
D.E. Beaudette
}
