#' Lookup tables for sand, silt, clay, texture class, and textural modifiers.
#' 
#' A list that contains a snapshot of the values generated using the logic from
#' the particle size estimator calculation in NASIS, the average values per
#' texture class, and average rock fragment values by textural modifier.
#' 
#' A list that contains a snapshot of the values generated using the logic from
#' the particle size estimator calculation in NASIS, and the average values per
#' texture class.
#' 
#' @name soiltexture
#' @docType data
#' @format A list with 3 data frames. The first named values which contains
#' values for sand, silt and clay by texture class. The second with average
#' values for sand, silt and clay per texture class. The third has fragvoltot
#' low, rv and high values for texmod.  \describe{ \item{list("clay")}{clay
#' percentage of the fine earth fraction, a integer vector}
#' \item{list("sand")}{sand percentage of the fine earth fraction, a integer
#' vector} \item{list("silt")}{silt percentage of the fine earth fraction, a
#' integer vector} \item{list("texcl")}{texture class, a character vector}
#' \item{list("texmod")}{textural modifiers, a character vector} }
#' @keywords datasets
NULL
#' Lookup tables for sand, silt, clay, texture class, and textural modifiers.
#' 
#' A list that contains a snapshot of the values generated using the logic from
#' the particle size estimator calculation in NASIS, the average values per
#' texture class, and average rock fragment values by textural modifier.
#' 
#' A list that contains a snapshot of the values generated using the logic from
#' the particle size estimator calculation in NASIS, and the average values per
#' texture class.
#' 
#' @name soiltexture
#' @docType data
#' @format A list with 3 data frames. The first named values which contains
#' values for sand, silt and clay by texture class. The second with average
#' values for sand, silt and clay per texture class. The third has fragvoltot
#' low, rv and high values for texmod.  \describe{ \item{list("clay")}{clay
#' percentage of the fine earth fraction, a integer vector}
#' \item{list("sand")}{sand percentage of the fine earth fraction, a integer
#' vector} \item{list("silt")}{silt percentage of the fine earth fraction, a
#' integer vector} \item{list("texcl")}{texture class, a character vector}
#' \item{list("texmod")}{textural modifiers, a character vector} }
#' @keywords datasets
NULL
