% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzBoundary.R
\name{hzTopographyCodeToOffset}
\alias{hzTopographyCodeToOffset}
\title{Convert Horizon Boundary Topography to Vertical Offset}
\usage{
hzTopographyCodeToOffset(
  x,
  codes = c("S", "W", "I", "B"),
  offset = c(0, 4, 8, 12)
)
}
\arguments{
\item{x}{vector of boundary topography codes to be converted}

\item{codes}{code values, adjust as needed}

\item{offset}{vertical offset (depth units) used to create "chevron" effect}
}
\value{
vector of vertical offsets with same length as \code{x}
}
\description{
This function will convert USDA-NCSS horizon boundary topography codes into a vertical offset, suitable for use in \code{plotSPC}. Default values are reasonable starting points for encoding smooth, wavy, irregular, or broken style horizon boundary topography as defined in \href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}.
}
\details{
Additional examples are available in the \href{https://ncss-tech.github.io/AQP/aqp/hz-boundaries.html}{Visualization of Horizon Boundaries tutorial}.
}
\references{
\href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}
}
\seealso{
\code{\link{plotSPC}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
