% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/prune.R
\name{dist2root}
\alias{dist2root}
\alias{get_postorder}
\alias{new_aphylo_pruner}
\alias{aphylo_pruner}
\title{Pointer to \code{pruner}}
\usage{
dist2root(ptr)

get_postorder(ptr)

new_aphylo_pruner(x, ...)
}
\arguments{
\item{ptr}{An object of class \code{aphylo_pruner}.}

\item{x}{An object of class \link{aphylo} or \link{multiAphylo}.}

\item{...}{Further arguments passed to the method}
}
\value{
\code{dist2root}: An integer vector with the number of steps from each
node (internal or not) to the root node.

\code{get_postorder}: An integer vector with the postorder sequence
for pruning the tree (indexed from 0).

The function \code{new_aphylo_pruner} returns an object of class
\code{aphylo_pruner} or \code{multiAphylo_pruner}, depending on the class of \code{x}.
}
\description{
Creates an external pointer to an object of class \code{aphylo_pruner}. This is mostly
used to compute the model's likelihood function faster by reusing underlying
C++ class objects to store probability matrices and data. This is intended
for internal use only.
}
\details{
The underlying implementation of the pruning function is based on the
pruner C++ library that implements Felsenstein's tree pruning algorithm.
See \url{https://github.com/USCbiostats/pruner}.
}
\examples{
set.seed(1)
x  <- raphylo(20) 
pruner <- new_aphylo_pruner(x)

# Computing loglike
LogLike(
  pruner,
  psi  = c(.10, .20),
  mu_d = c(.90, .80),
  mu_s = c(.10, .05),
  Pi   = .05,
  eta  = c(.90, .80)
  )
  
dist2root(pruner)
get_postorder(pruner)
}
