% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark-box.R
\name{spark_box}
\alias{spark_box}
\title{Create a box with a sparkline}
\usage{
spark_box(
  data,
  title = NULL,
  subtitle = NULL,
  color = "#2E93fA",
  background = "#FFF",
  type = c("area", "line", "spline", "column"),
  synchronize = NULL,
  title_style = NULL,
  subtitle_style = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{A \code{data.frame}-like object with at least two columns,
first is mapped to x-axis, second to y-axis.}

\item{title}{Title to display in the box.}

\item{subtitle}{Subtitle to display in the box.}

\item{color}{Color of the chart.}

\item{background}{Background color of the box.}

\item{type}{Type of chart, currently type supported are :
\code{"area"} (default), \code{"line"}, \code{"spline"}, \code{"column"}.}

\item{synchronize}{Give a common id to charts to synchronize them (tooltip and zoom).}

\item{title_style, subtitle_style}{A \code{list} of named attributes to style
the title / subtitle, possible values are \code{fontSize},
\code{fontWeight}, \code{fontFamily}, \code{color}.}

\item{width, height}{A numeric input in pixels.}

\item{elementId}{Use an explicit element ID for the widget.}
}
\value{
An \code{apexcharts} \code{htmlwidget} object.
}
\description{
Create a box with a sparkline
}
\note{
In Shiny use \code{sparkBoxOutput} / \code{renderSparkBox} to render boxes, see example.
Boxes have CSS class \code{"apexcharter-spark-box"} if you need more styling.
}
\examples{
library(apexcharter)

spark_data <- data.frame(
  date = Sys.Date() + 1:20,
  var1 = round(rnorm(20, 50, 10)),
  var2 = round(rnorm(20, 50, 10)),
  var3 = round(rnorm(20, 50, 10))
)

spark_box(
  data = spark_data,
  title = mean(spark_data$var1), 
  subtitle = "Variable 1"
)


# In Shiny
if (interactive()) {
  run_sparkbox_demo()
}

}
