% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/apaDescriptives.R
\name{apa.descriptives}
\alias{apa.descriptives}
\title{Generic method to generate an APA style table with descriptives for MS Word.}
\usage{
apa.descriptives(data = data.frame(), variables = NULL, report = "",
  title = "APA Table", filename = "APA Table.docx", note = NULL,
  position = "lower", merge = FALSE, landscape = FALSE, save = TRUE)
}
\arguments{
\item{data}{Raw dataset with variables.}

\item{variables}{The variable names for in the table.}

\item{report}{(optional) Specify which descriptive statistics to report. Use a subset from \code{c("M", "SD", "r")}.}

\item{title}{(optional) Name of the table.}

\item{filename}{(optional) Specify the filename (including valid '\code{.docx}' extension).}

\item{note}{(optional) Add a footnote to the bottom of the table.}

\item{position}{(optional) Specify whether the correlations should be displayed in the \code{upper}, or \code{lower} diagonal of the table.}

\item{merge}{(optional) Set (\code{TRUE}) if the mean and standard deviation columns should be merged into one column.}

\item{landscape}{(optional) Set (\code{TRUE}) if the table should be generated in landscape mode.}

\item{save}{(optional) Set (\code{FALSE}) if the table should not be saved in a document.}
}
\value{
\code{apa.descriptives} object; a list consisting of
\item{succes}{message in case of an error}
\item{save}{flag which indicates whther the document is saved}
\item{data}{dataset with descriptive statistics}
\item{table}{\code{FlexTable {ReporteRs}} object}
}
\description{
Generic method to generate an APA style table with descriptives for MS Word.
}
\examples{
# Use apa.descriptives function
apa.descriptives(
  data = data.frame(
    rnorm(100, mean = 0, sd = 1),
    rnorm(100, mean = 0, sd = 1),
    rnorm(100, mean = 0, sd = 1),
    rnorm(100, mean = 0, sd = 1)
  ),
  variables = c("Column 1", "Column 2", "Column 3", "Column 4")
)
}

