% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoristic.summary.R
\name{aoristic.summary}
\alias{aoristic.summary}
\title{Summarize weekly aoristic weights}
\usage{
aoristic.summary(data1, output = "")
}
\arguments{
\item{data1}{a data frame output from the aoristic.df function}

\item{output}{output ='xlsx' for an Excel format output
#' output ='jpg' for JPG grid, blank otherwise}
}
\value{
A data frame with aoristic values summed for each hour of the week
}
\description{
Summarizes the sum of aoristic weights for each hour of the week, based on output from an aoristic data 
frame (created by aoristic.df). The function returns a data frame, with optional outputs. 
Option 'xlsx' sends the data frame to an Excel spreadsheet in the current working directory. 
Filenames increment to prevent overwriting previous analyses. Using option 'jpg' 
creates a color coded summary table in jpg format in the working directory.
The filename is aoristic_distribution.jpg, adding incremental numbers as necessary to the filename.
 
NOTE: Be aware that the distribution of values is NOT the same as the aoristic.ref() output, because
the summary charts and graphs move Sunday to the end of the week to keep the weekend together.
}
\examples{
\dontrun{

aor.summary <- aoristic.summary(aor.df)
aor.summary <- aoristic.summary(aor.df, 'xlsx')
aor.summary <- aoristic.summary(aor.df, 'jpg')
}
}
\references{
Ratcliffe, J. H. (2002). Aoristic signatures and the spatio-temporal analysis of high volume crime patterns. Journal of Quantitative Criminology, 18(1), 23-43.
}
