% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aop_cytoscape_methods.R
\docType{methods}
\name{getAOPNodeName}
\alias{getAOPNodeName}
\alias{getAOPNodeName,aop_cytoscape-method}
\title{Get Node Name from ID}
\usage{
getAOPNodeName(theObject, id)

\S4method{getAOPNodeName}{aop_cytoscape}(theObject, id)
}
\arguments{
\item{theObject}{is an AOP as an object of class \code{aop_cytoscape}.}

\item{id}{an object of class \code{character} such as "389".}
}
\value{
the name of the node
}
\description{
Given an id, this method returns an \code{aop_cytoscape} node name.
}
\examples{
library(graph)
steatosis_json_file <- system.file("extdata", "steatosis_aop_json.cyjs",
package = "aop")
steatosis_aop <- convert_cytoscape_to_aop(steatosis_json_file)
getAOPNodeName(steatosis_aop, "389")
}

