% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{get_stats}
\alias{get_stats}
\title{Calculate Anscombe's summary statistics}
\usage{
get_stats(x)
}
\arguments{
\item{x}{a numeric matrix or data frame with at least 2 columns/variables.
Each column contains observations on a different variable.  Missing
observations are not allowed.}
}
\value{
A named list of summary statistics containing
\itemize{
\item \code{n} The sample size.
\item \code{means} The sample means of each variable.
\item \code{variances} The sample means of each variable.
\item \code{correlation} The sample correlation matrix.
\item \code{intercepts},\code{slopes},\code{rsquared} Matrices whose (i,j)th entries are the
estimated regression coefficients in a regression of \code{x[, i]} on
\code{x[, j]} and the resulting coefficient of determination \eqn{R^2}.
}
}
\description{
Calculates a particular set of summary statistics for a dataset.
}
\examples{
get_stats(anscombe[, c(1, 5)])
}
