% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{clean_export_files}
\alias{clean_export_files}
\title{Cleans all animal GPS datasets (in .csv format) in a chosen directory. Optionally exports the clean data as spreadsheets, a single .rds data file, or as a list of data frames}
\usage{
clean_export_files(
  data_dir,
  tz_in = "UTC",
  tz_out = "UTC",
  export = FALSE,
  cleaned_filename = NULL,
  cleaned_dir = NULL
)
}
\arguments{
\item{data_dir}{directory of GPS tracking files (in csv)}

\item{tz_in}{input time zone, defaults to UTC}

\item{tz_out}{output time zone, defaults to UTC}

\item{export}{logical, whether to export the clean data, defaults to False}

\item{cleaned_filename}{full name of output file (ending in .rds) when export is True}

\item{cleaned_dir}{directory to save the processed GPS datasets as spreadsheets (.csv) when export is True}
}
\value{
list of cleaned animal GPS datasets
}
\description{
Cleans all animal GPS datasets (in .csv format) in a chosen directory. Optionally exports the clean data as spreadsheets, a single .rds data file, or as a list of data frames
}
\examples{
# Clean all animal GPS .csv datasets in the demo directory

clean_export_files(system.file("extdata", "demo_nov19", package = "animaltracker"))
}
