% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_rss.R
\name{check_factors}
\alias{check_factors}
\title{Check factor levels}
\usage{
check_factors(model, x1, x2)
}
\arguments{
\item{x1}{\verb{[data.frame]} \cr A \code{data.frame} representing the habitat values
at location x_1. Must contain all fitted covariates as expected by
\code{predict()}.}

\item{x2}{\verb{[data.frame]} \cr A 1-row \code{data.frame} representing the single
hypothetical location of x_2. Must contain all fitted covariates as expected
by \code{predict()}.}

\item{object}{\verb{[glm, clogit]} \cr The model object from a fitted RSF/(i)SSF.
\emph{I.e.}, it will be \code{object$model} when called within \code{log_rss()}.}
}
\description{
Check factor levels before log-RSS calculation
}
\details{
This function is meant for internal use by \code{log_rss()} and is
not meant to be called by the user.
}
\examples{

\dontrun{
#Load data
data("amt_fisher")

# Prepare data for RSF
rsf_data <- amt_fisher \%>\%
  filter(name == "Lupe") \%>\%
  make_track(x_, y_, t_) \%>\%
  random_points() \%>\%
  extract_covariates(amt_fisher_covar$elevation) \%>\%
  extract_covariates(amt_fisher_covar$popden) \%>\%
  extract_covariates(amt_fisher_covar$landuse) \%>\%
  mutate(lu = factor(landuse))

# Fit RSF without factor
m1 <- rsf_data \%>\%
  fit_rsf(case_ ~ elevation + popden)

# data.frame of x1s
x1 <- data.frame(elevation = seq(90, 120, length.out = 100),
                 popden = mean(rsf_data$popden))
# data.frame of x2 (note factor levels should be same as model data)
x2 <- data.frame(elevation = mean(rsf_data$elevation),
                 popden = mean(rsf_data$popden))

# Function should return NULL (no factors to check)
check_factors(m1$model, x1, x2)

# Fit RSF with factor
m2 <- rsf_data \%>\%
  fit_rsf(case_ ~ lu + elevation + popden)

# data.frame of x1s
x1 <- data.frame(lu = factor(50, levels = levels(rsf_data$lu)),
                 elevation = seq(90, 120, length.out = 100),
                 popden = mean(rsf_data$popden))
# data.frame of x2 (note factor levels should be same as model data)
x2 <- data.frame(lu = factor(50, levels = levels(rsf_data$lu)),
                 elevation = mean(rsf_data$elevation),
                 popden = mean(rsf_data$popden))

# Function should return NULL (no discrepancies)
check_factors(m2, x1, x2)

# Now misspecify factor for x1
x1 <- data.frame(lu = factor(50),
                 elevation = seq(90, 120, length.out = 100),
                 popden = mean(rsf_data$popden))

# Function should return informative errors regarding data vs x1 and x1 vs x2
check_factors(m2$model, x1, x2)

# Also misspecify factor for x2
x2 <- data.frame(lu = factor(50),
                 elevation = mean(rsf_data$elevation),
                 popden = mean(rsf_data$popden))

# Function should return informative errors regarding data vs x1 and data vs x2
check_factors(m2$model, x1, x2)
}

}
\keyword{internal}
