% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_modis_daily}
\alias{calc_modis_daily}
\title{A single-date MODIS worker for parallelization}
\usage{
calc_modis_daily(
  from = NULL,
  locs = NULL,
  locs_id = "site_id",
  radius = 0L,
  date = NULL,
  name_extracted = NULL,
  fun_summary = "mean",
  max_cells = 3e+07,
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatRaster. Preprocessed objects.}

\item{locs}{SpatVector/sf/sftime object. Locations where MODIS values
are summarized.}

\item{locs_id}{character(1). Field name where unique site identifiers
are stored. Default is \code{"site_id"}}

\item{radius}{numeric. Radius to generate circular buffers.}

\item{date}{Date(1). date to query.}

\item{name_extracted}{character. Names of calculated covariates.}

\item{fun_summary}{function. Summary function for
multilayer rasters. Passed to \code{foo}. See \code{\link[exactextractr:exact_extract]{exactextractr::exact_extract}}
for details.}

\item{max_cells}{integer(1). Maximum number of cells to be read at once.
Higher values will expedite processing, but will increase memory usage.
Maximum possible value is \code{2^31 - 1}.}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.}
See \code{\link[exactextractr:exact_extract]{exactextractr::exact_extract}} for details.}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object.
}
\description{
The function operates at MODIS/VIIRS products
on a daily basis. Given that the raw hdf files are downloaded from
NASA, standard file names include a data retrieval date flag starting
with letter "A". Leveraging that piece of information, the function will
select files of scope on the date of interest.
Please note that this function does not provide a function to filter
swaths or tiles, so it is strongly recommended to check and pre-filter
the file names at users' discretion.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
locs <- data.frame(lon = -78.8277, lat = 35.95013, id = "001")
calc_modis_daily(
  from = mod06l2_warp, # dervied from process_modis() example
  locs = locs,
  locs_id = "id",
  radius = 0,
  date = "2024-01-01",
  name_extracted = "cloud_fraction_0",
  fun_summary = "mean",
  max_cells = 3e7
)
}
}
\seealso{
\itemize{
\item Preprocessing: \code{\link[=process_modis_merge]{process_modis_merge()}}, \code{\link[=process_modis_swath]{process_modis_swath()}},
\code{\link[=process_blackmarble]{process_blackmarble()}}
\item Parallelization: \code{\link[=calc_modis_par]{calc_modis_par()}}
}
}
\author{
Insang Song
}
