% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{simulate_congeneric}
\alias{simulate_congeneric}
\title{Simulate observations from a congeneric one-factor model.}
\usage{
simulate_congeneric(
  n,
  k,
  sigma = 1,
  lambda = 1,
  latent = stats::rnorm,
  error = stats::rnorm
)
}
\arguments{
\item{n}{Number of observations.}

\item{k}{Size of matrix or number of testlets.}

\item{sigma}{Vector of error standard deviations.
Repeated to have \code{k} elements.}

\item{lambda}{Vector of factor loadings. Repeated to have \code{k} elements.}

\item{latent}{Distribution of the latent variable.}

\item{error}{Distribution of the error variable.}
}
\value{
Covariance matrix.
}
\description{
Simulate observations from a one-factor model with specified latent variable
and error variable distributions. The error terms are not correlated,
hence the model is congeneric.
}
\keyword{internal}
