% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feglm.nb.R
\name{feglm.nb}
\alias{feglm.nb}
\title{Efficiently fit negative binomial glm's with high-dimensional \eqn{k}-way fixed effects}
\usage{
feglm.nb(formula = NULL, data = NULL, beta.start = NULL,
  eta.start = NULL, init.theta = NULL, link = c("log", "identity",
  "sqrt"), control = NULL)
}
\arguments{
\item{formula, data, beta.start, eta.start, control}{see \code{\link{feglm}}.}

\item{init.theta}{an optional initial value for the theta parameter (see \code{\link[MASS]{glm.nb}}).}

\item{link}{the link function. Must be one of \code{"log"}, \code{"sqrt"}, or \code{"identity"}.}
}
\value{
The function \code{feglm.nb} returns a named list of class \code{"feglm"}.
}
\description{
\code{feglm.nb} can be used to fit negative binomial generalized linear models with many 
high-dimensional fixed effects (see \code{\link{feglm}}).
}
\details{
If \code{feglm.nb} does not converge this is usually a sign of linear dependence between one or 
more regressors and a fixed effects category. In this case, you should carefully inspect your
model specification.
}
\references{
Gaure, S. (2013). "OLS with Multiple High Dimensional Category Variables". Computational
Statistics and Data Analysis. 66.

Stammann, A., F. Heiss, and D. McFadden (2016). "Estimating Fixed Effects Logit Models with Large
Panel Data". Working paper.

Stammann, A. (2018). "Fast and Feasible Estimation of Generalized Linear Models with
High-Dimensional k-Way Fixed Effects". ArXiv e-prints.
}
\seealso{
\code{\link[MASS]{glm.nb}}, \code{\link{feglm}}
}
