% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alma-seq.R
\name{alma_seq}
\alias{alma_seq}
\title{Generate date sequences}
\usage{
alma_seq(from, to, rschedule, inclusive = TRUE)
}
\arguments{
\item{from, to}{\verb{[Date(1)]}

Dates defining the range to look for events.}

\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule or rbundle.}

\item{inclusive}{\verb{[logical(1)]}

If \code{from} or \code{to} are events in the \code{rschedule}, should they be removed
from the sequence?}
}
\value{
A vector of dates in the range of \verb{[from, to]}, with all events in the
\code{rschedule} removed.
}
\description{
\code{alma_seq()} generates a sequence of all dates between \code{from} and \code{to},
skipping any events defined by the \code{rschedule}.
}
\examples{
on_weekends <- weekly() \%>\% recur_on_weekends()

# Generate a sequence of all non-weekend dates in Jan-2000
alma_seq("2000-01-01", "2000-01-31", on_weekends)
}
