% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_speedglm.R
\name{all_speedglm}
\alias{all_speedglm}
\title{Effect estimates from all possible models using \code{speedglm}}
\usage{
all_speedglm(crude, xlist, data, family = binomial(), na_omit = TRUE, ...)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of characters with variable names to be included in
as potential confounding factors.}

\item{data}{\emph{Data frame}.}

\item{family}{Description of the error distribution. Default is \code{binomial()}.}

\item{na_omit}{Remove all missing values. Default is \code{"na_omit = TRUE"}.}

\item{...}{Further optional arguments.}
}
\value{
A list of all effect estimates.
}
\description{
This is a faster alternative to \code{all_glm}. \code{all_speedglm}
estimates odds ratios or rate ratios using generalized linear
models (\code{speedglm}) with all possible combinations of a list of variables
(potential confounding factors) specified in \code{xlist} argument.
}
\examples{
\dontrun{
#' vlist <- c("Age", "Sex", "Cancer", "CVD", "Education")
results <- all_speedglm(crude = "Endpoint ~ Diabetes", xlist = vlist, data = diab_df)
results$estimate
all_plot(results)
}
}
\seealso{
\pkg{speedglm}
}
