% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/windows.R
\docType{methods}
\name{window_sliding}
\alias{window_sliding}
\alias{window_sliding-method}
\alias{window_sliding,integer,integer-method}
\alias{window_sliding,numeric,numeric-method}
\title{Sliding Windows}
\usage{
window_sliding(n, m, ...)

\S4method{window_sliding}{integer,integer}(n, m, i = NULL)

\S4method{window_sliding}{numeric,numeric}(n, m, i = NULL)
}
\arguments{
\item{n}{An \code{\link{integer}} giving the length of the data series (will be coerced
with \code{\link[=as.integer]{as.integer()}} and hence truncated toward zero).}

\item{m}{An odd \code{\link{integer}} giving the window size, i.e. the number of
adjacent points to be used (will be coerced with \code{\link[=as.integer]{as.integer()}} and hence
truncated toward zero).}

\item{...}{Currently not used.}

\item{i}{A vector \code{\link{integer}} specifying the indices of the data points for
which windows should be returned. If \code{NULL} (the default), windows are
evaluated for each data point.}
}
\value{
Returns a length-\eqn{n} \code{\link{list}} of \code{\link{integer}} vectors (indices of the
data points in each window).
}
\description{
There will be \eqn{(m - 1) / 2} points both at the beginning and at the end
of the data series for which a complete \eqn{m}-width window cannot be
obtained. To prevent data loss, progressively wider/narrower windows are
evaluated at both ends of the data series.
}
\examples{
## Length of the data series
n <- 10

## Progressive sliding windows
sliding <- window_sliding(n = n, m = 5)

plot(NULL, xlim = c(1, n), ylim = c(1, 10.5), xlab = "Index", ylab = "Window")
for (i in seq_along(sliding)) {
  w <- sliding[[i]]
  text(x = w, y = rep(i, length(w)), labels = w, pos = 3)
  lines(w, rep(i, length(w)), type = "l", lwd = 2)
}

## Tumbling windows
## (compare with drop = TRUE)
tumbling <- window_tumbling(n = n, m = 3, drop = FALSE)

plot(NULL, xlim = c(1, n), ylim = c(1, 5.5), xlab = "Index", ylab = "Window")
for (i in seq_along(tumbling)) {
  w <- tumbling[[i]]
  text(x = w, y = rep(i, length(w)), labels = w, pos = 3)
  lines(w, rep(i, length(w)), type = "l", lwd = 2)
}

}
\seealso{
Other moving windows: 
\code{\link{window_tumbling}()}
}
\author{
N. Frerebeau
}
\concept{moving windows}
