% Generated by roxygen2 (4.0.2): do not edit by hand
\name{condorcet}
\alias{condorcet}
\title{Find a Condorcet Choice.}
\usage{
condorcet(data, names)
}
\arguments{
\item{data}{the data, a vector of counts of each permutation of the m objects (m is the length of data)}

\item{names}{character vector of the names of the m objects}
}
\value{
...
}
\description{
Try to compute find a Condorcet choice given a full ranking of m objects.
}
\details{
In a ranking of m objects, the Condorcet choice is the choice that wins over every other choice in pairwise comparisons.  See Marden (1995), p.20 for details.
}
\examples{
data(city)

condorcet(city[,"city"], colnames(city))    # among city-dwellers
condorcet(city[,"suburb"], colnames(city))  # among suburb-dwellers
condorcet(city[,"country"], colnames(city)) # among country-dwellers
condorcet(rowSums(city), colnames(city))    # overall winner
}
\references{
Marden, J. I. (1995). \emph{Analyzing and Modeling Rank Data}, London: Chapman & Hall. p.20.
}
\seealso{
\code{\link{Pmaker}}
}

