% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareVGA.R
\name{createGrid}
\alias{createGrid}
\title{Create a PointMap through a grid}
\usage{
createGrid(minX, minY, maxX, maxY, gridSize, verbose = FALSE)
}
\arguments{
\item{minX}{Minimum X of the bounding region}

\item{minY}{Minimum Y of the bounding region}

\item{maxX}{Maximum X of the bounding region}

\item{maxY}{Maximum Y of the bounding region}

\item{gridSize}{Size of the cells}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
A new PointMap
}
\description{
Create a PointMap through a grid
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
lineStringMap <- as(sfMap, "sf")
mapRegion <- sf::st_bbox(lineStringMap)
createGrid(
  minX = mapRegion[["xmin"]],
  minY = mapRegion[["ymin"]],
  maxX = mapRegion[["xmax"]],
  maxY = mapRegion[["ymax"]],
  gridSize = 0.04
)
}
