% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_clean.R
\name{keyword_clean}
\alias{keyword_clean}
\title{Automatic keyword cleaning and transfer to tidy format}
\usage{
keyword_clean(
  df,
  id = "id",
  keyword = "keyword",
  sep = ";",
  rmParentheses = TRUE,
  rmNumber = TRUE,
  lemmatize = FALSE,
  lemmatize_dict = NULL
)
}
\arguments{
\item{df}{A data.frame containing at least two columns with document ID and keyword strings with separators.}

\item{id}{Quoted characters specifying the column name of document ID.Default uses "id".}

\item{keyword}{Quoted characters specifying the column name of keywords.Default uses "keyword".}

\item{sep}{Separator(s) of keywords. Default uses ";".}

\item{rmParentheses}{Remove the contents in the parentheses (including the parentheses) or not. Default
uses TRUE.}

\item{rmNumber}{Remove the pure number sequence or no. Default uses TRUE.}

\item{lemmatize}{Lemmatize the keywords or not. Lemmatization is supported by `lemmatize_strings` function
in `textstem` package.Default uses FALSE.}

\item{lemmatize_dict}{A dictionary of base terms and lemmas to use for replacement.
Only used when the \bold{lemmatize} parameter is \code{TRUE}.
The first column should be the full word form in lower case
while the second column is the corresponding replacement lemma.
Default uses \code{NULL}, this would apply the default dictionary used in
\code{\link[textstem]{lemmatize_strings}} function.}
}
\value{
A tbl with two columns, namely document ID and cleaned keywords.
}
\description{
Carry out several keyword cleaning processes automatically and return a tidy table with
document ID and keywords.
}
\details{
The entire cleaning processes include:
1.Split the text with separators;
2.Remove the contents in the parentheses (including the parentheses);
3.Remove white spaces from start and end of string and reduces repeated white spaces inside a string;
4.Remove all the null character string and pure number sequences;
5.Convert all letters to lower case;
6.Lemmatization.
Some of the procedures could be suppressed or activated with parameter adjustments.
Default setting did not use lemmatization, it is suggested to use \code{\link[akc]{keyword_merge}} to
merge the keywords afterward.
}
\examples{
library(akc)

bibli_data_table

bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword")
}
\seealso{
\code{\link[akc]{keyword_merge}}
}
