% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent_trait.R
\name{latent_trait_analysis}
\alias{latent_trait_analysis}
\title{Performs the latent trait analysis}
\usage{
latent_trait_analysis(df, paras, min_item = 0, max_item = 1)
}
\arguments{
\item{df}{The performance data in a matrix or dataframe.}

\item{paras}{The parameters from fitting \code{cirtmodel}.}

\item{min_item}{A vector with the minimum performance value for each algorithm.}

\item{max_item}{A vector with the maximum performance value for each algorithm.}
}
\value{
A list with the following components:
\item{\code{crmtheta}}{The problem trait output computed from the R package EstCRM.}
\item{\code{crmtheta}}{The problem trait output computed from the R package EstCRM.}
\item{\code{latent}}{Thelatent trait occupancy of each algorithm.}
\item{\code{dfl}}{The dataset in a long format of latent trait occupancy.}
\item{\code{plt}}{The ggplot object showing the fitted smoothing splines.}
}
\description{
This function performs the latent trait analysis of the datasets/problems after fitting a continuous IRT model. It fits a smoothing spline to the points to compute the latent trait.
}
\examples{
set.seed(1)
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
X <- cbind.data.frame(x1, x2, x3)
max_item <- rep(1,3)
min_item <- rep(0,3)
mod <- cirtmodel(X, max.item=max_item, min.item=min_item)
out <- latent_trait_analysis(X, mod$model$param, min_item= min_item, max_item = max_item)
out

}
