% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/calendar.R
\docType{methods}
\name{calendar_get}
\alias{calendar_get}
\alias{calendar_label}
\alias{calendar_label-method}
\alias{calendar_name}
\alias{calendar_name-method}
\alias{calendar_unit}
\alias{calendar_unit-method}
\alias{calendar_epoch}
\alias{calendar_epoch-method}
\alias{calendar_fixed}
\alias{calendar_fixed-method}
\alias{calendar_direction}
\alias{calendar_direction-method}
\alias{calendar_label,TimeScale-method}
\alias{calendar_name,TimeScale-method}
\alias{calendar_unit,TimeScale-method}
\alias{calendar_epoch,TimeScale-method}
\alias{calendar_fixed,TimeScale-method}
\alias{calendar_direction,TimeScale-method}
\alias{calendar_direction,NULL-method}
\title{Calendar Parameters}
\usage{
calendar_label(object)

calendar_name(object)

calendar_unit(object)

calendar_epoch(object)

calendar_fixed(object)

calendar_direction(object)

\S4method{calendar_label}{TimeScale}(object)

\S4method{calendar_name}{TimeScale}(object)

\S4method{calendar_unit}{TimeScale}(object)

\S4method{calendar_epoch}{TimeScale}(object)

\S4method{calendar_fixed}{TimeScale}(object)

\S4method{calendar_direction}{TimeScale}(object)

\S4method{calendar_direction}{NULL}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{TimeScale}} object.}
}
\value{
\itemize{
\item \code{calendar_label()} returns a \code{\link{character}} string specifying the
abbreviated label of the time scale.
\item \code{calendar_name()} returns a \code{\link{character}} string specifying the name of
the time scale.
\item \code{calendar_unit()} returns a \code{\link{character}} string specifying the name of
the calendar.
\item \code{calendar_fixed()} returns a length-one \code{\link{numeric}} vector specifying the
reference date of the calendar (in \emph{rata die}).
\item \code{calendar_epoch()} returns a length-one \code{\link{numeric}} vector specifying the
epoch year from which years are counted (starting date of the calendar,
in years).
\item \code{calendar_direction()} returns a length-one \code{\link{integer}} vector specifying
if years are counted backwards (\eqn{-1}) or forwards (\eqn{1}) from
\code{epoch}. Only the \link[=sign]{sign} of \code{calendar_direction()} is relevant.
}
}
\description{
Calendar Parameters
}
\examples{
## Define time scales
calendar("BP")
calendar("AD")
calendar("julian")

## Shortcuts
BP()
AD()
J()
}
\seealso{
Other calendar tools: 
\code{\link{calendar}()},
\code{\link{convert}()},
\code{\link{gregorian}},
\code{\link{is}()},
\code{\link{julian}()}
}
\author{
N. Frerebeau
}
\concept{calendar tools}
