% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIFETransformerMaker.R
\name{aife_transformer.load_model}
\alias{aife_transformer.load_model}
\title{Load a transformer model}
\usage{
aife_transformer.load_model(
  type,
  model_dir,
  from_tf,
  load_safe,
  add_pooler = FALSE
)
}
\arguments{
\item{type}{\code{string} A type of the transformer. Allowed types are bert, roberta, funnel, longformer, mpnet, modernbert. See
\link{AIFETrType} list.}

\item{model_dir}{\code{string} Path to the directory where the original model is stored. Allowed values: any}

\item{from_tf}{\code{bool} Whether to load the model weights from a TensorFlow checkpoint save file.}

\item{load_safe}{\code{bool} Whether or not to use safetensors checkpoints.}

\item{add_pooler}{\code{bool} Whether to add a pooling layer, \code{FALSE} by default.}
}
\value{
If success - a transformer model, otherwise - an error (passed type is invalid).
}
\description{
Loads a model for a transformer with the passed type.
}
\seealso{
Other Transformers for developers: 
\code{\link{.AIFEModernBertTransformer}},
\code{\link{.AIFETrConfig}},
\code{\link{.AIFETrModel}},
\code{\link{.AIFETrModelMLM}},
\code{\link{.AIFETrObj}},
\code{\link{.AIFETrTokenizer}},
\code{\link{.aife_transformer.check_type}()},
\code{\link{aife_transformer.load_model_config}()},
\code{\link{aife_transformer.load_model_mlm}()},
\code{\link{aife_transformer.load_tokenizer}()}
}
\concept{Transformers for developers}
\keyword{internal}
