% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saving_and_loading.R
\name{save_ai_model}
\alias{save_ai_model}
\title{Saving models created with 'aifeducation'}
\usage{
save_ai_model(
  model,
  model_dir,
  dir_name = NULL,
  save_format = "default",
  append_ID = TRUE
)
}
\arguments{
\item{model}{Object of class \link{TextEmbeddingClassifierNeuralNet} or
\link{TextEmbeddingModel} which should be saved.}

\item{model_dir}{Path to the directory where the should model is stored.}

\item{dir_name}{Name of the folder that will be created at \code{model_dir}.
If\code{dir_name=NULL} the model's name will be used. If additionally \code{append_ID=TRUE}
the models's name and ID will be used for generating a name for that directory.}

\item{save_format}{Only relevant for \link{TextEmbeddingClassifierNeuralNet}.
Format for saving the model. For 'tensorflow'/'keras' models
\code{"keras"} for 'Keras v3 format',
\code{"tf"} for SavedModel
or \code{"h5"} for HDF5.
For 'pytorch' models \code{"safetensors"} for 'safetensors' or
\code{"pt"} for 'pytorch via pickle'.
Use \code{"default"} for the standard format. This is keras for
'tensorflow'/'keras' models and safetensors for 'pytorch' models.}

\item{append_ID}{\code{bool} \code{TRUE} if the ID should be appended to
the model directory for saving purposes. \code{FALSE} if not.}
}
\value{
Function does not return a value. It saves the model to disk.

No return value, called for side effects.
}
\description{
Function for saving models created with 'aifeducation'.
}
\seealso{
Other Saving and Loading: 
\code{\link{load_ai_model}()}
}
\concept{Saving and Loading}
