% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{get_folds}
\alias{get_folds}
\title{Create cross-validation samples}
\usage{
get_folds(target, k_folds)
}
\arguments{
\item{target}{Named \code{factor} containing the relevant labels/categories. Missing cases
should be declared with \code{NA}.}

\item{k_folds}{\code{int} number of folds.}
}
\value{
Return a \code{list} with the following components:
\itemize{
\item{\code{val_sample: }\code{vector} of \code{strings} containing the names of cases of the validation sample.}

\item{\code{train_sample: }\code{vector} of \code{strings} containing the names of cases of the train sample.}

\item{\code{n_folds: }\code{int} Number of realized folds.}

\item{\code{unlabeled_cases: }\code{vector} of \code{strings} containing the names of the unlabeled cases.}
}
}
\description{
Function creates cross-validation samples and ensures that the relative
frequency for every category/label within a fold equals the relative frequency of
the category/label within the initial data.
}
\note{
The parameter \code{target} allows cases with missing categories/labels.
These should be declared with \code{NA}. All these cases are ignored for creating the
different folds. Their names are saved within the component \code{unlabeled_cases}.
These cases can be used for Pseudo Labeling.

the function checks the absolute frequencies of every category/label. If the
absolute frequency is not sufficient to ensure at least four cases in every fold,
the number of folds is adjusted. In these cases, a warning is printed to the console.
At least four cases per fold are necessary to ensure that the training of
\link{TextEmbeddingClassifierNeuralNet} works well with all options turned on.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{calc_standard_classification_measures}()},
\code{\link{check_embedding_models}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
\keyword{internal}
