% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_embedding_model.R
\name{EmbeddedText}
\alias{EmbeddedText}
\title{Embedded text}
\value{
Returns an object of class \code{EmbeddedText}. These objects are used
for storing and managing the text embeddings created with objects of class \link{TextEmbeddingModel}.
Objects of class \code{EmbeddedText} serve as input for classifiers of class
\link{TextEmbeddingClassifierNeuralNet}. The main aim of this class is to provide a structured link between
embedding models and classifiers. Since objects of this class save information on
the text embedding model that created the text embedding it ensures that only
embedding generated with same embedding model are combined. Furthermore, the stored information allows
classifiers to check if embeddings of the correct text embedding model are used for
training and predicting.
}
\description{
Object of class \link[R6]{R6} which stores the text embeddings
generated by an object of class \link{TextEmbeddingModel} via the method
\code{embed()}.
}
\seealso{
Other Text Embedding: 
\code{\link{TextEmbeddingModel}},
\code{\link{combine_embeddings}()}
}
\concept{Text Embedding}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{embeddings}}{('data.frame()')\cr
data.frame containing the text embeddings for all chunks. Documents are
in the rows. Embedding dimensions are in the columns.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EmbeddedText-new}{\code{EmbeddedText$new()}}
\item \href{#method-EmbeddedText-get_model_info}{\code{EmbeddedText$get_model_info()}}
\item \href{#method-EmbeddedText-get_model_label}{\code{EmbeddedText$get_model_label()}}
\item \href{#method-EmbeddedText-clone}{\code{EmbeddedText$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EmbeddedText-new"></a>}}
\if{latex}{\out{\hypertarget{method-EmbeddedText-new}{}}}
\subsection{Method \code{new()}}{
Creates a new object representing text embeddings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmbeddedText$new(
  model_name = NA,
  model_label = NA,
  model_date = NA,
  model_method = NA,
  model_version = NA,
  model_language = NA,
  param_seq_length = NA,
  param_chunks = NULL,
  param_overlap = NULL,
  param_aggregation = NULL,
  embeddings
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_name}}{\code{string} Name of the model that generates this embedding.}

\item{\code{model_label}}{\code{string} Label of the model that generates this embedding.}

\item{\code{model_date}}{\code{string} Date when the embedding generating model was created.}

\item{\code{model_method}}{\code{string} Method of the underlying embedding model.}

\item{\code{model_version}}{\code{string} Version of the model that generated this embedding.}

\item{\code{model_language}}{\code{string} Language of the model that generated this embedding.}

\item{\code{param_seq_length}}{\code{int} Maximum number of tokens that processes the generating model for a chunk.}

\item{\code{param_chunks}}{\code{int} Maximum number of chunks which are supported by the generating model.}

\item{\code{param_overlap}}{\code{int} Number of tokens that were added at the beginning of the sequence for the next chunk
by this model.}

\item{\code{param_aggregation}}{\code{string} Aggregation method of the hidden states.}

\item{\code{embeddings}}{\code{data.frame} containing the text embeddings.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an object of class \link{EmbeddedText} which stores the
text embeddings produced by an objects of class \link{TextEmbeddingModel}.
The object serves as input for objects of class \link{TextEmbeddingClassifierNeuralNet}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EmbeddedText-get_model_info"></a>}}
\if{latex}{\out{\hypertarget{method-EmbeddedText-get_model_info}{}}}
\subsection{Method \code{get_model_info()}}{
Method for retrieving information about the model that
generated this embedding.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmbeddedText$get_model_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} contains all saved information about the underlying
text embedding model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EmbeddedText-get_model_label"></a>}}
\if{latex}{\out{\hypertarget{method-EmbeddedText-get_model_label}{}}}
\subsection{Method \code{get_model_label()}}{
Method for retrieving the label of the model that
generated this embedding.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmbeddedText$get_model_label()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{string} Label of the corresponding text embedding model
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EmbeddedText-clone"></a>}}
\if{latex}{\out{\hypertarget{method-EmbeddedText-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmbeddedText$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
