% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-reflexivity.R
\name{rel_is_reflexive}
\alias{rel_is_reflexive}
\alias{rel_closure_reflexive}
\alias{rel_reduction_reflexive}
\title{Reflexive Binary Relations}
\usage{
rel_is_reflexive(R)

rel_closure_reflexive(R)

rel_reduction_reflexive(R)
}
\arguments{
\item{R}{an object coercible to a 0-1 (logical) square matrix,
representing a binary relation on a finite set.}
}
\value{
The \code{rel_closure_reflexive} and
\code{rel_reduction_reflexive} functions
return a logical square matrix. \code{\link{dimnames}}
of \code{R} are preserved.

On the other hand, \code{rel_is_reflexive} returns
a single logical value.
}
\description{
A binary relation \eqn{R} is reflexive, iff
for all \eqn{x} we have \eqn{xRx}.
}
\details{
\code{rel_is_reflexive} finds out if a given binary relation
is reflexive. The function just checks whether all elements
on the diagonal of \code{R} are non-zeros,
i.e., it has \eqn{O(n)} time complexity,
where \eqn{n} is the number of rows in \code{R}.
Missing values on the diagonal may result in \code{NA}.

A reflexive closure of a binary relation \eqn{R},
determined by \code{rel_closure_reflexive},
is the minimal reflexive superset \eqn{R'} of \eqn{R}.

A reflexive reduction of a binary relation \eqn{R},
determined by \code{rel_reduction_reflexive},
is the minimal subset \eqn{R'} of \eqn{R},
such that the reflexive closures of \eqn{R} and \eqn{R'} are equal
i.e., the largest irreflexive relation contained in \eqn{R}.
}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{pord_weakdom}}, \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}},
  \code{\link{rel_reduction_hasse}}
}
\concept{binary_relations}
