% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plot_cluster_network}
\alias{plot_cluster_network}
\title{Network plot of a (low dimensional) ADPROCLUS solution}
\usage{
plot_cluster_network(
  model,
  title = "Cluster network of ADPROCLUS solution",
  relative_overlap = TRUE,
  filetype = NULL,
  filename = NULL,
  ...
)
}
\arguments{
\item{model}{ADPROCLUS solution (class: \code{adpc}). Low dimensional model
possible.}

\item{title}{String. Default: " Cluster network of ADPROCLUS solution"}

\item{relative_overlap}{Logical. If \code{TRUE} (default), the number of
observations belonging to two clusters
is divided by the total number of observations. If \code{FALSE}
the number of observations in a cluster overlap will be displayed on the
edges.}

\item{filetype}{Optional. Choose type of file to save the plot.
Possible choices: \code{"R", "pdf", "svg", "tex", "jpg", "tiff", "png", ""}
Default: \code{NULL} does not create a file.}

\item{filename}{Optional. Name of the file without extension.}

\item{...}{Additional arguments passing to the
\code{qgraph::qgraph()} function, to customize the graph visualization.}
}
\value{
Invisibly returns the input model.
}
\description{
Produce a representation of a (low dimensional) ADPROCLUS solution,
where each cluster is a vertex and the edge between two vertices represents
the overlap between the corresponding clusters.
The size of a vertex corresponds to the cluster size.
The overlap is represented through color, width and numerical label
of the edge.
The numerical edge labels can be relative
(number of overlap observations / total observations)
or absolute (number of observations in both clusters).
\strong{NOTE:} This function can be called through the
\code{plot(model, type = "Network")} function with model an
object of class \code{adpc}.
}
\examples{
# Loading a test dataset into the global environment
x <- stackloss

# Quick low dimensional clustering with K = 3 clusters and S = 1 dimensions
clust <- adproclus_low_dim(x, 3, 1)

# Plot the overlapping the clusters
plot_cluster_network(clust)
}
