% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{aw_auth}
\alias{aw_auth}
\alias{auth_jwt}
\alias{auth_oauth}
\title{Generate an access token for Adobe Analytics 2.0}
\usage{
aw_auth(type = aw_auth_with(), ...)

auth_jwt(
  client_id = Sys.getenv("AW_CLIENT_ID"),
  client_secret = Sys.getenv("AW_CLIENT_SECRET"),
  private_key = Sys.getenv("AW_PRIVATE_KEY"),
  org_id = Sys.getenv("AW_ORGANIZATION_ID"),
  tech_id = Sys.getenv("AW_TECHNICAL_ID"),
  jwt_token = NULL,
  ...
)

auth_oauth(
  client_id = Sys.getenv("AW_CLIENT_ID"),
  client_secret = Sys.getenv("AW_CLIENT_SECRET"),
  use_oob = TRUE
)
}
\arguments{
\item{type}{Either 'jwt' or 'oauth'. Defaults to 'oauth'.}

\item{...}{Arguments passed to auth functions.}

\item{client_id}{Client ID}

\item{client_secret}{Client secret}

\item{private_key}{File path to private key for token signature}

\item{org_id}{Organization ID from integration console}

\item{tech_id}{Technical account ID from integration console}

\item{jwt_token}{Optional, a custom, encoded, signed JWT claim. If used,
only \code{client_id} and \code{client_secret} are required.}

\item{use_oob}{if \code{FALSE}, use a local webserver for the OAuth dance.
Otherwise, provide a URL to the user and prompt for a validation code.
Defaults to the value of the \code{httr_oob_default} default, or TRUE if
\code{httpuv} is not installed.}
}
\value{
The path of the cached token, invisibly
}
\description{
\code{auth_oauth} and \code{auth_jwt} should not be called directly, as these do not cache
the token.
}
\section{Functions}{
\itemize{
\item \code{auth_jwt}: Authenticate with JWT token

\item \code{auth_oauth}: Authorize via OAuth 2.0
}}

\concept{auth}
