% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{log_sum_of_logs}
\alias{log_sum_of_logs}
\title{Computes the log of a sum of numbers all given in log-space.}
\usage{
log_sum_of_logs(log_values)
}
\arguments{
\item{log_values}{Sequence of numbers in log space \eqn{[\log(x_1), \log(x_2), ..., \log(x_n)]}}
}
\value{
\eqn{\log(\sum_{i=1}^n x_i)}
}
\description{
Given a sequence of numbers \eqn{[\log(x_1), \log(x_2), ..., \log(x_n)]}, computes \eqn{\log(\sum_{i=1}^n x_i)}.
For adding two numbers that are given in log space we use the expression \code{max(x, y) + log1p(exp( -abs(x - y) ))}
which is a good approximation if \code{x} and \code{y} are of the same order of magnitude, but if they
are of very different sizes just returns the maximum of the two. To prevent adding numbers of very different
magnitude we iteratively add the numbers pairwise. Because of nummerical issues with doing this, the order
of the input values can affect the result.
}

