% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_model.R
\name{plot.admix_model}
\alias{plot.admix_model}
\title{Plot method for objects of class 'admix_model'}
\usage{
\method{plot}{admix_model}(x, ...)
}
\arguments{
\item{x}{An object of class 'admix_model'.}

\item{...}{A list of additional parameters belonging to the default method.}
}
\description{
Plots the probability density function of the known component of the admixture model, where
we recall that an admixture model has probability density function (pdf) l_i such that:
l_i = p_i * f_i + (1-p_i) * g_i, with g_i the known component density.
The unknown quantities are therefore p_i and f_i.
}
\examples{
plot(admix_model(knownComp_dist = "norm", knownComp_param = list("mean"=0, "sd"=1)))
plot(admix_model(knownComp_dist = "pois", knownComp_param = list("lambda"=1.5)))

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
