% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBM_k_samples_test.R
\name{IBM_tabul_stochasticInteg}
\alias{IBM_tabul_stochasticInteg}
\title{Simulated distribution of the contrast using IBM}
\usage{
IBM_tabul_stochasticInteg(
  samples,
  admixMod,
  min_size = NULL,
  n.varCovMat = 80,
  n_sim_tab = 100,
  parallel = FALSE,
  n_cpu = 2
)
}
\arguments{
\item{samples}{A list of the two samples under study.}

\item{admixMod}{A list of two objects of class 'admix_model', with information about distributions and parameters.}

\item{min_size}{(optional, NULL by default) In the k-sample case, useful to provide the minimal size among all samples
(needed to take into account the correction factor for variance-covariance assessment). Otherwise, useless.}

\item{n.varCovMat}{(default to 80) Number of time points at which the Gaussian processes are simulated.}

\item{n_sim_tab}{(default to 100) Number of simulated Gaussian processes when tabulating the inner convergence distribution
in the 'icv' testing method using the IBM estimation approach.}

\item{parallel}{(default to FALSE) Boolean to indicate whether parallel computations are performed (speed-up the tabulation).}

\item{n_cpu}{(default to 2) Number of cores used when paralleling computations.}
}
\value{
A list with four elements, containing: 1) random draws of the contrast as defined in the reference given here;
2) estimated unknown component weights for the two admixture models; 3) the value of the the empirical contrast;
4) support that was used to evaluate the variance-covariance matrix of the empirical processes.
}
\description{
Tabulate the distribution related to the inner convergence part of the contrast, by simulating trajectories of Gaussian
processes and applying some transformations. Useful to perform the test hypothesis, by retrieving the (1-alpha)-quantile
of interest. See 'Details' below and the cited paper therein for further information.
}
\examples{
\donttest{
## Simulate mixture data:
mixt1 <- twoComp_mixt(n = 1200, weight = 0.4,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(list("mean" = -2, "sd" = 0.5),
                                        list("mean" = 0, "sd" = 1)))
mixt2 <- twoComp_mixt(n = 1000, weight = 0.7,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(list("mean" = -2, "sd" = 0.5),
                                        list("mean" = 1, "sd" = 1)))
data1 <- getmixtData(mixt1)
data2 <- getmixtData(mixt2)
## Define the admixture models:
admixMod1 <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                         knownComp_param = mixt1$comp.param[[2]])
admixMod2 <- admix_model(knownComp_dist = mixt2$comp.dist[[2]],
                         knownComp_param = mixt2$comp.param[[2]])
IBM_tabul_stochasticInteg(samples = list(data1, data2), admixMod = list(admixMod1, admixMod2),
                          min_size=NULL, n.varCovMat=20, n_sim_tab=2, parallel=FALSE, n_cpu=2)
}

}
\references{
\insertRef{MilhaudPommeretSalhiVandekerkhove2024a}{admix}
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
