% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_function}
\alias{assert_function}
\title{Is Argument a Function?}
\usage{
assert_function(arg, params = NULL, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{params}{A character vector of expected argument names}

\item{optional}{Is the checked argument optional?

If set to \code{FALSE} and \code{arg} is \code{NULL} then an error is thrown.}
}
\value{
The function throws an error
\itemize{
\item if the argument is not a function or
\item if the function does not provide all arguments as specified for the
\code{params} argument.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{assert_function_param()} instead.
}
\details{
Checks if the argument is a function and if all expected arguments are
provided by the function.
}
\examples{
example_fun <- function(fun) {
  assert_function(fun, params = c("x"))
}

example_fun(mean)

try(example_fun(1))

try(example_fun(sum))
}
\seealso{
Other deprecated: 
\code{\link{assert_has_variables}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_order_vars}()}
}
\concept{deprecated}
\keyword{deprecated}
