% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_duration.R
\name{compute_duration}
\alias{compute_duration}
\title{Compute Duration}
\usage{
compute_duration(
  start_date,
  end_date,
  in_unit = "days",
  out_unit = "days",
  floor_in = TRUE,
  add_one = TRUE,
  trunc_out = FALSE,
  type = "duration"
)
}
\arguments{
\item{start_date}{The start date

A date or date-time object is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Refer to \code{convert_dtc_to_dt()} to obtain a vector of imputed dates.

\describe{
\item{Default value}{none}
}}

\item{end_date}{The end date

A date or date-time object is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Refer to \code{convert_dtc_to_dt()} to obtain a vector of imputed dates.

\describe{
\item{Default value}{none}
}}

\item{in_unit}{Input unit

See floor_in and add_one parameter for details.

Permitted Values (case-insensitive):

For years: \code{"year"}, \code{"years"}, \code{"yr"}, \code{"yrs"}, \code{"y"}

For months: \code{"month"}, \code{"months"}, \code{"mo"}, \code{"mos"}

For days: \code{"day"}, \code{"days"}, \code{"d"}

For hours: \code{"hour"}, \code{"hours"}, \code{"hr"}, \code{"hrs"}, \code{"h"}

For minutes: \code{"minute"}, \code{"minutes"}, \code{"min"}, \code{"mins"}

For seconds: \code{"second"}, \code{"seconds"}, \code{"sec"}, \code{"secs"}, \code{"s"}

\describe{
\item{Default value}{\code{"days"}}
}}

\item{out_unit}{Output unit

The duration is derived in the specified unit

Permitted Values (case-insensitive):

For years: \code{"year"}, \code{"years"}, \code{"yr"}, \code{"yrs"}, \code{"y"}

For months: \code{"month"}, \code{"months"}, \code{"mo"}, \code{"mos"}

For weeks: \code{"week"}, \code{"weeks"}, \code{"wk"}, \code{"wks"}, \code{"w"}

For days: \code{"day"}, \code{"days"}, \code{"d"}

For hours: \code{"hour"}, \code{"hours"}, \code{"hr"}, \code{"hrs"}, \code{"h"}

For minutes: \code{"minute"}, \code{"minutes"}, \code{"min"}, \code{"mins"}

For seconds: \code{"second"}, \code{"seconds"}, \code{"sec"}, \code{"secs"}, \code{"s"}

\describe{
\item{Default value}{\code{"days"}}
}}

\item{floor_in}{Round down input dates?

The input dates are round down with respect to the input unit, e.g., if the
input unit is 'days', the time of the input dates is ignored.

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{TRUE}}
}}

\item{add_one}{Add one input unit?

If the duration is non-negative, one input unit is added. i.e., the
duration can not be zero.

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{TRUE}}
}}

\item{trunc_out}{Return integer part

The fractional part of the duration (in output unit) is removed, i.e., the
integer part is returned.

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{FALSE}}
}}

\item{type}{lubridate duration type.

See below for details.

\describe{
\item{Permitted values}{\code{"duration"}, \code{"interval"}}
\item{Default value}{\code{"duration"}}
}}
}
\value{
The duration between the two date in the specified unit
}
\description{
Compute duration between two dates, e.g., duration of an adverse event,
relative day, age, ...
}
\details{
The output is a numeric vector providing the duration as time from
start to end date in the specified unit. If the end date is before the start
date, the duration is negative.
}
\section{Duration Type}{


The \href{https://lubridate.tidyverse.org/}{lubridate} package calculates two
types of spans between two dates: duration and interval.
While these calculations are largely the same, when the unit of the time period
is month or year the result can be slightly different.

The difference arises from the ambiguity in the length of \code{"1 month"} or
\code{"1 year"}.
Months may have 31, 30, 28, or 29 days, and years are 365 days and 366 during leap years.
Durations and intervals help solve the ambiguity in these measures.

The \strong{interval} between \code{2000-02-01} and \code{2000-03-01} is \code{1} (i.e. one month).
The \strong{duration} between these two dates is \code{0.95}, which accounts for the fact
that the year 2000 is a leap year, February has 29 days, and the average month
length is \code{30.4375}, i.e. \code{29 / 30.4375 = 0.95}.

For additional details, review the
\href{https://lubridate.tidyverse.org/reference/timespan.html}{lubridate time span reference page}.
}

\examples{
library(lubridate)

# Derive duration in days (integer), i.e., relative day
compute_duration(
  start_date = ymd_hms("2020-12-06T15:00:00"),
  end_date = ymd_hms("2020-12-24T08:15:00")
)

# Derive duration in days (float)
compute_duration(
  start_date = ymd_hms("2020-12-06T15:00:00"),
  end_date = ymd_hms("2020-12-24T08:15:00"),
  floor_in = FALSE,
  add_one = FALSE
)

# Derive age in years
compute_duration(
  start_date = ymd("1984-09-06"),
  end_date = ymd("2020-02-24"),
  trunc_out = TRUE,
  out_unit = "years",
  add_one = FALSE
)

# Derive duration in hours
compute_duration(
  start_date = ymd_hms("2020-12-06T9:00:00"),
  end_date = ymd_hms("2020-12-06T13:30:00"),
  out_unit = "hours",
  floor_in = FALSE,
  add_one = FALSE,
)
}
\seealso{
\code{\link[=derive_vars_duration]{derive_vars_duration()}}

Date/Time Computation Functions that returns a vector: 
\code{\link{compute_age_years}()},
\code{\link{compute_dtf}()},
\code{\link{compute_tmf}()},
\code{\link{convert_date_to_dtm}()},
\code{\link{convert_dtc_to_dt}()},
\code{\link{convert_dtc_to_dtm}()},
\code{\link{impute_dtc_dt}()},
\code{\link{impute_dtc_dtm}()}
}
\concept{com_date_time}
\keyword{com_date_time}
