% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_confirmation.R
\name{min_cond}
\alias{min_cond}
\title{Minimum Value on a Subset}
\usage{
min_cond(var, cond)
}
\arguments{
\item{var}{A vector}

\item{cond}{A condition}
}
\description{
The function derives the minimum value of a vector/column on a subset of
entries/observations.
}
\examples{

library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(admiral)
data <- tribble(
  ~USUBJID, ~AVISITN, ~AVALC,
  "1",      1,        "PR",
  "1",      2,        "CR",
  "1",      3,        "NE",
  "1",      4,        "CR",
  "1",      5,        "NE",
  "2",      1,        "CR",
  "2",      2,        "PR",
  "2",      3,        "CR",
)

# In oncology setting, when needing to check the first time a patient had
# a Complete Response (CR) to compare to see if any Partial Response (PR)
# occurred after this add variable indicating if PR occurred after CR
group_by(data, USUBJID) \%>\% mutate(
  first_cr_vis = min_cond(var = AVISITN, cond = AVALC == "CR"),
  last_pr_vis = max_cond(var = AVISITN, cond = AVALC == "PR"),
  pr_after_cr = last_pr_vis > first_cr_vis
)
}
\seealso{
Utilities for Filtering Observations: 
\code{\link{count_vals}()},
\code{\link{filter_confirmation}()},
\code{\link{filter_extreme}()},
\code{\link{filter_relative}()},
\code{\link{max_cond}()}
}
\author{
Stefan Bundfuss
}
\concept{utils_fil}
\keyword{utils_fil}
