% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_pchg.R
\name{derive_var_pchg}
\alias{derive_var_pchg}
\title{Derive Percent Change from Baseline}
\usage{
derive_var_pchg(dataset)
}
\arguments{
\item{dataset}{The input dataset. Required variables are \code{AVAL} and
\code{BASE}.}
}
\value{
The input dataset with an additional column named \code{PCHG}
}
\description{
Derive percent change from baseline (\code{PCHG}) in a BDS dataset
}
\details{
Percent change from baseline is calculated by dividing change from
baseline by the absolute value of the baseline value and
multiplying the result by \code{100}.
}
\examples{
library(tibble)

advs <- tribble(
  ~USUBJID, ~PARAMCD, ~AVAL, ~ABLFL, ~BASE,
  "P01",    "WEIGHT", 80,    "Y",    80,
  "P01",    "WEIGHT", 80.8,  "",     80,
  "P01",    "WEIGHT", 81.4,  "",     80,
  "P02",    "WEIGHT", 75.3,  "Y",    75.3,
  "P02",    "WEIGHT", 76,    "",     75.3
)
derive_var_pchg(advs)
}
\seealso{
\code{\link[=derive_var_chg]{derive_var_chg()}}

BDS-Findings Functions that returns variable appended to dataset: 
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_shift}()}
}
\author{
Thomas Neitmann
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
