% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_query.R
\name{assert_valid_queries}
\alias{assert_valid_queries}
\title{Verify if a Dataset Has the Required Format as Queries Dataset.}
\usage{
assert_valid_queries(queries, queries_name)
}
\arguments{
\item{queries}{A data.frame.}

\item{queries_name}{Name of the queries dataset, a string.}
}
\value{
The function throws an error if any of the requirements not met.
}
\description{
Verify if a Dataset Has the Required Format as Queries Dataset.
}
\details{
Check if the dataset has the following columns
\itemize{
\item \code{VAR_PREFIX}, e.g., SMQ01, CQ12
\item \code{QUERY_NAME}, non NA, must be unique per each \code{VAR_PREFIX}
\item \code{QUERY_ID}, could be NA, must be unique per each \code{VAR_PREFIX}
\item \code{QUERY_SCOPE}, 'BROAD', 'NARROW', or NA
\item \code{QUERY_SCOPE_NUM}, 1, 2, or NA
\item \code{TERM_LEVEL}, e.g., \code{"AEDECOD"}, \code{"AELLT"}, \code{"AELLTCD"}, ...
\item \code{TERM_NAME}, character, could be NA only at those observations
where \code{TERM_ID} is non-NA
\item \code{TERM_ID}, integer, could be NA only at those observations
where \code{TERM_NAME} is non-NA
}
}
\examples{
data("queries")
assert_valid_queries(queries, "queries")
}
\seealso{
Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_terms}()},
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{tte_source}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\author{
Shimeng Huang, Ondrej Slama
}
\concept{source_specifications}
\keyword{source_specifications}
