% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_has_variables}
\alias{assert_has_variables}
\title{Does a Dataset Contain All Required Variables?}
\usage{
assert_has_variables(dataset, required_vars)
}
\arguments{
\item{dataset}{A \code{data.frame}}

\item{required_vars}{A \code{character} vector of variable names}
}
\value{
The function throws an error if any of the required variables are
missing in the input dataset. Otherwise, the dataset is returned invisibly.
}
\description{
Checks if a dataset contains all required variables
}
\examples{
library(admiral.test)
data(admiral_dm)

assert_has_variables(admiral_dm, "STUDYID")

try(assert_has_variables(admiral_dm, "AVAL"))
}
\author{
Thomas Neitmann
}
\keyword{assertion}
