% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_data.R
\name{assert_db_requirements}
\alias{assert_db_requirements}
\title{Check required parameters for a basket}
\usage{
assert_db_requirements(
  version,
  version_arg_name,
  fun,
  fun_arg_name,
  queries,
  i
)
}
\arguments{
\item{version}{Version provided by user}

\item{version_arg_name}{Name of the argument providing the version}

\item{fun}{Function provided by user}

\item{fun_arg_name}{Name of the argument providing the function}

\item{queries}{Queries provide by user}

\item{i}{Index of query being checked}
}
\value{
An error is issued if \code{version} or \code{fun} is null.
}
\description{
If a basket (SMQ, SDG, ....) are requested, the version and a function to access the
database must be provided. The function checks these requirements.
}
\seealso{
Other Advanced Functions: 
\code{\link{assert_parameters_argument}()},
\code{\link{assert_terms}()},
\code{\link{assert_valid_queries}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{get_hori_data}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\concept{other_advanced}
\keyword{other_advanced}
