% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_joined.R
\name{count_vals}
\alias{count_vals}
\title{Count Number of Observations Where a Variable Equals a Value}
\usage{
count_vals(var, val)
}
\arguments{
\item{var}{A vector}

\item{val}{A value}
}
\description{
Count number of observations where a variable equals a value.
}
\examples{

library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(admiral)
data <- tribble(
  ~USUBJID, ~AVISITN, ~AVALC,
  "1",      1,        "PR",
  "1",      2,        "CR",
  "1",      3,        "NE",
  "1",      4,        "CR",
  "1",      5,        "NE",
  "2",      1,        "CR",
  "2",      2,        "PR",
  "2",      3,        "CR",
  "3",      1,        "CR",
  "4",      1,        "CR",
  "4",      2,        "NE",
  "4",      3,        "NE",
  "4",      4,        "CR",
  "4",      5,        "PR"
)

# add variable providing the number of NEs for each subject
group_by(data, USUBJID) \%>\%
  mutate(nr_nes = count_vals(var = AVALC, val = "NE"))
}
\seealso{
Utilities for Filtering Observations: 
\code{\link{filter_extreme}()},
\code{\link{filter_joined}()},
\code{\link{filter_relative}()},
\code{\link{max_cond}()},
\code{\link{min_cond}()}
}
\concept{utils_fil}
\keyword{utils_fil}
