% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msabe.R
\name{msabe}
\alias{msabe}
\title{Run the mixed scaling approach in bioequivalence (BE) studies}
\usage{
msabe(Test, Reference, params = list())
}
\arguments{
\item{Test}{An n-by-r matrix of test product data. \code{n} is the number of donors and \code{r} is the number of skin section replicates.}

\item{Reference}{An n-by-r matrix of reference product data.}

\item{params}{(Optional) The list of tuning parameters for running the test.
\itemize{
\item \code{sigma_W0} - A regulatory constant set by the FDA. Defaults to 0.25.
\item \code{m} - Another regulatory constant that determines the bounds within which the estimated GMR should fall for bioequivalence to be established. Defaults to 1.25, representing 80-125\% average BE limits, which is the FDA recommendation.
\item \code{sig_level} - The significance level (alpha-level).
}}
}
\value{
A list of lists
\itemize{
\item \code{parameters} - A list of true parameter settings.
\item \code{fout} - The test result and related estimators.
\item \code{runtime} - The total elapsed time charged for the execution of the program.
}
}
\description{
This function runs hypothesis testing for bioequivalence using the mixed criterion
}
\examples{
n <- 6
r <- 3
Test <- matrix(runif(n*r), nrow = n, ncol = r)
Reference <- matrix(runif(n*r), nrow = n, ncol = r)
out <- msabe(Test, Reference)

}
\references{
Davit, B. M., Chen, M. L., Conner, D. P., Haidar, S. H., Kim, S., Lee, C. H., Lionberger, R. A., Makhlouf, F. T., Nwakama, P. E., Patel, D. T., Schuirmann, D. J., & Yu, L. X. (2012). Implementation of a reference-scaled average bioequivalence approach for highly variable generic drug products by the US Food and Drug Administration. The AAPS journal, 14(4), 915-924.
}
\author{
Daeyoung Lim, \email{daeyoung.lim@uconn.edu}
}
